#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								      MEMO
//********************************************************************************
/*-RF remote control decode
Head : High(5ms) + Low(7.8ms) 
Stop   : Low(150ms)

330us,780us
1 = High(780us) + Low(330us)
0 = High(330us) + Low(780us)

First remote control:
				      address 20bits          data 12bits
	"1" 	=	1111 1110 0010 1011 1111 	1000 0111 1100 
	"2"		=	1111 1110 0010 1011 1111 	1001 0110 1100
	"3"		=	1111 1110 0010 1011 1111 	0101 1010 1100
	"4"		=	1111 1110 0010 1011 1111 	1100 0011 1100
	"OFF"	=	1111 1110 0010 1011 1111 	1101 0010 1100
	"SMART" =	1111 1110 0010 1011 1111 	0011 1100 1100
	"3H"	=	1111 1110 0010 1011 1111 	0010 1101 1100
	"6H"	=	1111 1110 0010 1011 1111 	0001 1110 1100
	"9H"	=	1111 1110 0010 1011 1111 	0100 1011 1100
	
Sec remote control:
				      address 20bits          data 12bits
	"1" 	=	1111 0111 0011 0000 0111 	1000 0111 1100 
	"2"		=	1111 0111 0011 0000 0111 	1001 0110 1100
	"3"		=	1111 0111 0011 0000 0111 	0101 1010 1100
	"4"		=	1111 0111 0011 0000 0111 	1100 0011 1100
	"OFF"	=	1111 0111 0011 0000 0111 	1101 0010 1100		
	"SMART" =	1111 0111 0011 0000 0111 	0011 1100 1100
	"3H"	=	1111 0111 0011 0000 0111 	0010 1101 1100
	"6H"	=	1111 0111 0011 0000 0111 	0001 1110 1100
	"9H"	=	1111 0111 0011 0000 0111 	0100 1011 1100
*/
xdata 	uint8 RF_Channel = 0;
#if (RF_Control == 1)
	uint8 	IR_Byte[5];
	xdata 	uint8	RF_Address[3];
	uint8 	test_ir;
//********************************************************************************
//								  RFDecode_Init
//********************************************************************************
	void RFDecode_Init (void){
		uint8	dRF_CLK_DIV_SEL;
		uint16	dRF_STOP_TIME;
		uint16	dRF_HEADER1_TIME,dRF_HEADER2_TIME;
		
		IR_DEC_SET = IR_DEC_SET_REGS;
		
		#if ((IR_DEC_SET_REGS&0x07)==0x00)
			#define 	CLK_DIV_SEL		24
		#elif ((IR_DEC_SET_REGS&0x07)==0x01)
			#define 	CLK_DIV_SEL		16
		#elif ((IR_DEC_SET_REGS&0x07)==0x02)
			#define 	CLK_DIV_SEL		8
		#elif ((IR_DEC_SET_REGS&0x07)==0x03)
			#define 	CLK_DIV_SEL		6
		#elif ((IR_DEC_SET_REGS&0x07)==0x04)
			#define 	CLK_DIV_SEL		3
		#elif ((IR_DEC_SET_REGS&0x07)==0x05)
			#define 	CLK_DIV_SEL		2
		#endif
		
		dRF_CLK_DIV_SEL = CLK_DIV_SEL;
		dRF_HEADER1_TIME = IR_HEADER1_TIME;
		dRF_HEADER2_TIME = IR_HEADER2_TIME;
		dRF_STOP_TIME = IR_HEADER1_TIME;
		
		IR_HEADER_Z1_H = ((dRF_HEADER1_TIME * dRF_CLK_DIV_SEL)>>8);		
		IR_HEADER_Z1_L = (dRF_HEADER1_TIME * dRF_CLK_DIV_SEL);
		
		IR_HEADER_Z2_H = ((dRF_HEADER2_TIME * dRF_CLK_DIV_SEL)>>8);		
		IR_HEADER_Z2_L = (dRF_HEADER2_TIME * dRF_CLK_DIV_SEL);
			
		IR_STOP_Z_H = ((dRF_STOP_TIME * dRF_CLK_DIV_SEL)>>8);			
		IR_STOP_Z_L = (dRF_STOP_TIME * dRF_CLK_DIV_SEL);
		
		
		IR_DEC_CTRL = IR_DEC_CTRL_REGS;
	}
//********************************************************************************
//								RF_Decode_Read
//********************************************************************************
	void RFDecode_Read (void){
		if((IR_DEC_CTRL & 0x10) == 0x10){
			IR_DEC_CTRL |= 0x01;
			IR_Byte[0] = IR_DOUT0;
			IR_Byte[1] = IR_DOUT1;
			IR_Byte[2] = IR_DOUT2;
			IR_Byte[3] = IR_DOUT3;
			IR_Byte[4] = IR_DOUT4;
			IR_Byte[5] = IR_DOUT5;
			
			#if (No_Remote_control_Learn_mode == 0)
				if(FLAG.RF_Learning_sw==0)
					IRLearning_mode();					//study mode
				
				if((IR_Byte[0]==RF_Address[0])&&(IR_Byte[1]==RF_Address[1])&&((IR_Byte[2]&0x0F)==RF_Address[2])){
			#else
				if((IR_Byte[0]==IR_ADDRESS_1)&&(IR_Byte[1]==IR_ADDRESS_2)&&((IR_Byte[2]&0x0F)==IR_ADDRESS_3)){
			#endif
				if(((IR_Byte[2]&0xF0)==RF_DATA_1_1)&&(IR_Byte[3]==RF_DATA_1_2)){		//"1"
					RF_Channel = R_1_SPEED;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_2_1)&&(IR_Byte[3]==RF_DATA_2_2)){	//"2"
					RF_Channel = R_2_SPEED;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_3_1)&&(IR_Byte[3]==RF_DATA_3_2)){	//"3"
					RF_Channel = R_3_SPEED;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_4_1)&&(IR_Byte[3]==RF_DATA_4_2)){	//"4"
					RF_Channel = R_4_SPEED;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_off_1)&&(IR_Byte[3]==RF_DATA_off_2)){	//"OFF"
					RF_Channel = R_OFF;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_smart_1)&&(IR_Byte[3]==RF_DATA_smart_2)){	//"SMART"
					RF_Channel = R_SMART;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_3H_1)&&(IR_Byte[3]==RF_DATA_3H_2)){	//"3H"
					RF_Channel = R_3H;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_6H_1)&&(IR_Byte[3]==RF_DATA_6H_2)){	//"6H"
					RF_Channel = R_6H;
				}
				else if(((IR_Byte[2]&0xF0)==RF_DATA_9H_1)&&(IR_Byte[3]==RF_DATA_9H_2)){	//"9H"
					RF_Channel = R_9H;
				}
			}
		}
		if(RF_Channel!=R_INIT){					//Execute remote control key
			#if (dIPWM_MODE == 1)
				if(FLAG.Buzzer_SW==0){
					FLAG.Buzzer_SW = 1;
					ipwm_counter = 0;
				}
			#endif
			RF_IR_Fun();
			
			#if (EEPROM_MODE==1)
				if(RF_Channel!=RF_Channel_temp){
					EEP_Erase();
					EEP_Write(0x00,SpeedNum);		//Remember the number of remote control speed segments after power down
					EEP_Write(0x01,RF_Address[0]);
					EEP_Write(0x02,RF_Address[1]);
					EEP_Write(0x03,RF_Address[2]);
				}
			#endif
		}
	}
//********************************************************************************
//								  IRLearning_mode
//********************************************************************************
	#if (No_Remote_control_Learn_mode == 0)
		void IRLearning_mode(void){
			if(((IR_Byte[2]&0xF0)==RF_DATA_off_1)&&(IR_Byte[3]==RF_DATA_off_2)){	//"OFF"
				test_ir++;
				if(test_ir>=Successful_Learning_TIMES){	
					test_ir = 0;
					// IPWM_CTRL = IPWM_EN;
					RF_Address[0] = IR_Byte[0];
					RF_Address[1] = IR_Byte[1];
					RF_Address[2] = (IR_Byte[2]&0x0F);
					
					EEP_Erase();
					EEP_Write(0x00,SpeedNum);		//Remember the number of remote control speed segments after power down
					EEP_Write(0x01,RF_Address[0]);
					EEP_Write(0x02,RF_Address[1]);
					EEP_Write(0x03,RF_Address[2]);
				}
			}
			else if((IR_Byte[2]==0)&&(IR_Byte[3]==0)){	// key release
				test_ir = 0;
			}
		}
	#endif
#endif